<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>History</title>
<style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        background: #f4efec;
        color: #092227;
    }
    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        display: flex;
        align-items: center;
        padding: 12px;
    }
    .nav-bar svg {
        width: 24px;
        height: 24px;
        fill: white;
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-bar-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Tabs */
    .tabs-box {
        background: white;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .van-tabs__wrap {
        overflow-x: auto;
    }
    .van-tabs__nav {
        display: flex;
        border-bottom: 2px solid #ddd;
    }
    .van-tab {
        flex: 1;
        text-align: center;
        padding: 12px 0;
        cursor: pointer;
        transition: 0.3s;
    }
    .van-tab--active {
        color: #092227;
        font-weight: bold;
        border-bottom: 3px solid #092227;
    }
    .van-tab__text p {
        margin: 0;
    }

    /* Content sections */
    .tab-content {
        padding: 20px;
        display: none;
    }
    .tab-content.active {
        display: block;
    }

    /* History styles */
    .history-list {
        margin: 0;
        padding: 0;
        list-style: none;
    }
    .history-list li {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: white;
        margin-bottom: 10px;
        padding: 10px;
        border-radius: 8px;
    }
    .history-amount {
        font-size: 16px;
        margin: 0;
    }
    .history-date {
        font-size: 14px;
        color: #0000009e;
        margin-top: 5px;
    }
    .status {
        padding: 5px 8px;
        border-radius: 42px;
        font-size: 14px;
    }
    .status.confirmed {
        color: green;
        background: #d9fdd3;
    }
    .status.pending {
        color: orange;
        background: #fff3cd;
    }
    .status.canceled {
        color: red;
        background: #f8d7da;
    }

    /* Deposit/Withdraw list custom style */
    .korufist {
        display: flex;
        flex-direction: column;
    }
    .kous-text {
        font-weight: bold;
    }
    .koux-text {
        font-size: 13px;
        color: #555;
    }
    .kou-right {
        text-align: right;
    }
</style>
</head>
<body>

<!-- Header -->
<div class="nav-bar">
    <svg onclick="window.history.back()" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
        <path d="M15.41 7.41 14 6l-6 6 6 6 1.41-1.41L10.83 12z"/>
    </svg>
    <div class="nav-bar-title">History</div>
</div>

<!-- Tabs -->
<div class="tabs-box">
    <div class="van-tabs__wrap">
        <div role="tablist" class="van-tabs__nav van-tabs__nav--line van-tabs__nav--complete" aria-orientation="horizontal">
            <div role="tab" class="van-tab van-tab--line van-tab--grow van-tab--active" onclick="showTab(0)">
                <span class="van-tab__text"><p>Account</p></span>
            </div>
            <div role="tab" class="van-tab van-tab--line van-tab--grow" onclick="showTab(1)">
                <span class="van-tab__text"><p>Deposit</p></span>
            </div>
            <div role="tab" class="van-tab van-tab--line van-tab--grow" onclick="showTab(2)">
                <span class="van-tab__text"><p>Withdraw</p></span>
            </div>
        </div>
    </div>
</div>

<!-- Account Tab -->
<div class="tab-content active" id="tab-0">
    <h3>Account History</h3>
    @if(\App\Models\UserLedger::where('user_id', auth()->id())->orderByDesc('id')->count() > 0)
        <ul class="history-list">
            @foreach(\App\Models\UserLedger::where('user_id', auth()->id())->orderByDesc('id')->get() as $element)
                <li>
                    <div>
                        <h4 class="history-amount">{{ price($element->amount) }}</h4>
                        <p class="history-date">{{ $element->created_at }}</p>
                    </div>
                    <div>
                        @if($element->status == 'approved')
                            <span class="status confirmed">Confirmed</span>
                        @elseif($element->status == 'pending')
                            <span class="status pending">Processing</span>
                        @else
                            <span class="status canceled">Canceled</span>
                        @endif
                    </div>
                </li>
            @endforeach
        </ul>
    @else
        <p>No account history found.</p>
    @endif
</div>

<!-- Deposit Tab -->
<div class="tab-content" id="tab-1">
    <h3>Deposit History</h3>
    @if(\App\Models\Deposit::where('user_id', auth()->id())->orderBydesc('id')->count() > 0)
        <ul class="history-list">
            @foreach(\App\Models\Deposit::where('user_id', auth()->id())->orderBydesc('id')->get() as $element)
                <li>
                    <div class="korufist">
                        <div class="kous-text" style="width: 112px;">
                            @if($element->status == 'approved')
                                Successful Deposit
                            @elseif($element->status == 'pending')
                                Deposit Processing
                            @elseif($element->status == 'rejected')
                                Deposit Rejected
                            @endif
                        </div>
                        <div class="koux-text">{{ $element->created_at }}</div>
                    </div>
                    <div class="kou-right">
                        <span style="color:#092227;font-weight:bold;">{{ price($element->amount) }}</span>
                        <br>
                        <span style="font-size:12px;">Balance</span>
                    </div>
                </li>
            @endforeach
        </ul>
    @else
        <p>No deposit history found.</p>
    @endif
</div>

<!-- Withdraw Tab -->
<div class="tab-content" id="tab-2">
    <h3>Withdraw History</h3>
    @if(\App\Models\Withdrawal::where('user_id', auth()->id())->orderBydesc('id')->count() > 0)
        <ul class="history-list">
            @foreach(\App\Models\Withdrawal::where('user_id', auth()->id())->orderBydesc('id')->get() as $element)
                <li>
                    <div class="korufist">
                        <div class="kous-text" style="width: 112px;">
                            @if($element->status == 'approved')
                                Successful Withdraw
                            @elseif($element->status == 'pending')
                                Withdraw Processing
                            @elseif($element->status == 'rejected')
                                Withdraw Rejected
                            @endif
                        </div>
                        <div class="koux-text">{{ $element->created_at }}</div>
                    </div>
                    <div class="kou-right">
                        <span style="color:#092227;font-weight:bold;">{{ price($element->amount) }}</span>
                        <br>
                        <span style="font-size:12px;">Balance</span>
                    </div>
                </li>
            @endforeach
        </ul>
    @else
        <p>No withdrawal history found.</p>
    @endif
</div>

<script>
    function showTab(index) {
        document.querySelectorAll('.van-tab').forEach((tab, i) => {
            tab.classList.toggle('van-tab--active', i === index);
        });
        document.querySelectorAll('.tab-content').forEach((content, i) => {
            content.classList.toggle('active', i === index);
        });
    }
</script>

</body>
</html>
