<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Customer Service</title>
<style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        background-color: #f4efec;
    }

    /* Header */
    .van-nav-bar {
        background-color: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .van-nav-bar__left {
        cursor: pointer;
        margin-right: 10px;
        font-size: 18px;
    }
    .van-nav-bar__title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Avatar */
    .avatar {
        display: block;
        width: 100px;
        height: 100px;
        margin: 20px auto;
        border-radius: 50%;
        border: 3px solid #092227;
    }

    /* Greeting text */
    .title {
        text-align: center;
        font-size: 22px;
        font-weight: bold;
        color: #092227;
        margin: 5px 0;
    }
    .text {
        text-align: center;
        color: #333;
        margin-bottom: 20px;
    }

    /* Online info box */
    .online-info {
        background: white;
        padding: 15px;
        max-width: 300px;
        margin: 0 auto 30px;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        text-align: center;
    }
    .info-title {
        font-weight: bold;
        margin-bottom: 10px;
    }
    .text-warp {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 10px;
    }
    .text-warp img {
        width: 20px;
        height: 20px;
    }

    /* Contact buttons */
    .contact-links {
        display: flex;
        justify-content: center;
        gap: 15px;
        margin-bottom: 40px;
    }
    .contact-links a {
        display: flex;
        align-items: center;
        gap: 8px;
        background-color: #092227;
        color: white;
        padding: 10px 15px;
        border-radius: 6px;
        text-decoration: none;
        font-weight: bold;
        transition: background 0.3s ease;
    }
    .contact-links a:hover {
        background-color: #0d3340;
    }
    .contact-links img {
        width: 22px;
        height: 22px;
    }
</style>
</head>
<body>

<!-- Header -->
<div class="van-nav-bar">
    <div class="van-nav-bar__left" onclick="window.location.href='{{ route('dashboard') }}'">←</div>
    <div class="van-nav-bar__title">Customer Service</div>
</div>

<!-- Avatar -->

<!-- Greeting -->
<p class="title">Hello</p>
<p class="text">I am your customer service assistant, how can I help?</p>

<!-- Online Time Info -->
<div class="online-info">
    <p class="info-title">Online Time</p>
    <div class="text-warp">
        <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAiCAYAAAA6RwvCAAAAAXNSR0IArs4c6QAAAxFJREFUWEe9mEuoTVEYx39XIULXgAwUIqU7uAwMyFve78H1JkIywEgM5DUTA1GK5BnCQN6PItezGHiUiYRk4FVuF3ER+p++Xavd2Xuvtfc5d83O2ev71m9/63vuGsJWd2AyMBKoA3oDXUxFM/AGeA40ApeBj77qazw3DgPWAZOAtp4yv4ErwA7gbpZMFkgfYA8wJaboB/AEeAk02bNaoB8wEOgQ238JWA28TgJKA5kH7AM6m7De8AxwFLgFtCQobQ+MAhYDDY4FvwIrgZPl5JJANgFbAD3/ZwDrzQeyrOw+lw9tN6BIl/RuiyspByKIrY4DLjeQEID4XlnmgOPYm+MwcRBdx3GzxHtgIvC0CIEjWw9cBXqYlRe41+SCyDF1qHxCoTiighARj2Bum2XkM/pdcmAX5KJFh3xijud1dAIUEVqKrG8e1tM1nbKzJTvVBVGeuGNKThuIh07GADds41jgpo+Qgcy2vcOVZyKLnAOmAwrR/gHRMR64ZgonANc9QRRNLyy0zwMzBKK0/c7+PAHIiXxXXhDpV1DMt5fvKZAlwCE7WVESvaEPTBEQWVBRpLVUIIIQjNJ215SMWQ6sCIgy8BcrB4cF8hAYDDwAhvqYwdlTBERq7gNDgEcCUanuBhyz+hDCUhREdWsR8EkgPwGZSVV2TQgFsArYmyNqomN2W1VuKQIyy/KB+pNfwADgVeCL7ALWKnLyXo0LodyjTHw2EELbj5g7fM7jrJWCEMg9C5DHoeFbSQhdqbq7jrJMSEKrJISsMc4pCct8U7yy4AUrA0V8wnUjpYuFwB+glOK1soreQaVhqwt5HdOF6GVFrx2g9mNaBJLVBqgib7BwDalFSYG0H1hhD9VoNxZtjHJEbElEVV5tacka+qO1W8UIXJ3daGukvsdB9LuazXOq9VprnMi8wmoPWIqOjTYZyDnVuZdd1Rg5lTGjkVMNskJUa6aliWAQCfgO4X+tu+sLDLK07R6osWFu2riR9TUgUpbns4QypnrSnfa9JNhZ0wSSPtS0senwLfDMpjlZ4UOml9qG/6oXz7CH5uw4AAAAAElFTkSuQmCC" alt="">
        <p>9:30 - 18:00</p>
    </div>
</div>

<!-- Contact Links -->
<div class="contact-links">
    <a href="https://t.me/JayDinTech" target="_blank">
        <img src="https://upload.wikimedia.org/wikipedia/commons/8/82/Telegram_logo.svg" alt="Telegram">
        Telegram
    </a>
    <a href="https://t.me/JayDinTech" target="_blank">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
        WhatsApp
    </a>
</div>

</body>
</html>
