<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Bind Bank Account</title>
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f4efec; /* Theme background */
        margin: 0;
        padding: 0;
    }

    /* Header */
    .nav-bar {
        background: #092227;
        color: white;
        padding: 12px;
        display: flex;
        align-items: center;
    }
    .nav-bar i {
        cursor: pointer;
        margin-right: 10px;
    }
    .nav-title {
        font-size: 18px;
        font-weight: bold;
    }

    /* Form Container */
    .form-container {
        padding: 15px;
        background: white;
        max-width: 400px;
        margin: 20px auto;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .form-container span {
        display: block;
        margin: 8px 0 4px;
        font-weight: bold;
    }
    .form-container input, 
    .form-container select {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 5px;
        outline: none;
        font-size: 14px;
        margin-bottom: 15px;
    }
    .form-container select {
        background: #092227;
        color: white;
    }
    .form-container img {
        height: 14px;
        vertical-align: middle;
        margin-right: 6px;
    }

    /* Button */
    .btn-submit {
        background: #092227;
        color: white;
        padding: 12px;
        width: 100%;
        border: none;
        border-radius: 5px;
        font-size: 16px;
        cursor: pointer;
    }
    .btn-submit:hover {
        background: #0d3344;
    }
</style>
</head>
<body>

<!-- Navigation -->
<div class="nav-bar">
    <i onclick="history.back()">←</i>
    <div class="nav-title">Bind Bank Account</div>
</div>
<?php
    $user = auth()->user();
?>
<!-- Form -->
<div class="form-container">
    <form action="<?php echo e(route('setup.gateway.submit')); ?>" method="post">
        <?php echo csrf_field(); ?>

        <span>* Account Name</span>
        <input autocomplete="off" type="text" id="bank_name" name="realname" value="<?php echo e($user->realname); ?>" placeholder="Enter your Account Name" required>

        <span>* Bank Name</span>
        <select name="gateway_method" required><?php
    $user = auth()->user();
?>
            <?php $__currentLoopData = \App\Models\BankList::where('status', '1')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $elemenet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($elemenet->bank_code); ?>" <?php if($user->gateway_method == $elemenet->bank_code): ?> selected <?php endif; ?>><?php echo e($elemenet->name); ?></option>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>

        <span>* Account Number</span>
        <input autocomplete="off" type="number" name="gateway_address" value="<?php echo e($user->gateway_address); ?>" placeholder="Enter your Account Number" required>

        <button type="submit" class="btn-submit">Submit</button>
    </form>
</div> 
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/mininggp/public_html/resources/views/app/main/add_bank_create.blade.php ENDPATH**/ ?>